﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace DicomEcho
{
    public partial class DicomEcho : Form
    {
        public DicomEcho()
        {
            InitializeComponent();
        }

        private async void buttonEcho_Click(object sender, EventArgs e)
        {
            try
            {
                labelRezultEcho.Text = "Wait...";
                labelRezultEcho.ForeColor = Color.Black;
                labelRezultEcho.Visible = true;

                if (await EchoRQ.EchoRSPAsync(
                                                textBoxLocalAet.Text,
                                                textBoxRemoteAet.Text,
                                                textBoxHostName.Text,
                                                int.Parse(textBoxDicomPort.Text)
                                              )
                   )
                {
                    labelRezultEcho.Text = "Success !";
                    labelRezultEcho.ForeColor = Color.Green;
                }
                else
                {
                    labelRezultEcho.Text = "Failed !";
                    labelRezultEcho.ForeColor = Color.Red;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show($"Error: {ex.Message}");
            }           
        }

        private void textBoxDicomPort_KeyPress(object sender, KeyPressEventArgs e)
        {
            char number = e.KeyChar;

            if (!Char.IsDigit(number) && number != 8)
            {
                e.Handled = true;
            }
        }
    }
}
