﻿using FellowOakDicom.Network.Client;
using FellowOakDicom.Network;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net;
using System.Windows.Forms;

namespace DicomEcho
{
    internal class EchoRQ
    {
        private static bool echoRezult = false;

        public static async Task<bool> EchoRSPAsync(string localAet, string remoteAet, string hostName, int dicomPort)
        {
            try
            {
                if (await EchoAsync(localAet, remoteAet, hostName, dicomPort))
                return echoRezult;
                else return false;
            }
            catch
            {
                return false;
            }
        }
        private static async Task <bool> EchoAsync(string localAet, string remoteAet, string hostName, int dicomPort)
        {

            try
            {                   
                var client = DicomClientFactory.Create(hostName, dicomPort, false, localAet, remoteAet);
                client.NegotiateAsyncOps();
                var requestEcho = new DicomCEchoRequest();
                requestEcho.OnResponseReceived += EchoResponse;


                await client.AddRequestAsync(requestEcho).ConfigureAwait(true);
                await client.SendAsync().ConfigureAwait(true);
                return true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                return false;

            }
        }


        private static void EchoResponse(DicomCEchoRequest request, DicomCEchoResponse response)
        {

            if (response.Status.ToString() == "Success")
            {
                echoRezult = true;
                return;
            }
            else
            {
                echoRezult = false;
            }

        }
    }
}
